/*! \file isptest.h

  \brief This file implements the ISP test program defines, types 
         and functions prototypes.
*/

#ifndef _ISPTEST_H_
#define _ISPTEST_H_

#define UNICODE
#define _UNICODE

#define NO_NEWLINE	false
#define NEWLINE		true
#define TAB "\t"

// ============================ Flow control =================================

#define SYNCHRO					1
#define READ_BLV				1
#define ERASE_BLOCK_0			0
#define FULL_ERASE				1
#define BLANK_CHECK				1
#define FILL_ZEROS				1
#define PARSE_HEX				0
#define READ_SINGLE_BYTE_BUFFER	0
#define PROGRAM_FLASH			1
#define VERIFY_FLASH			1
#define READ_FLASH				0
#define SELECT_EEPROM			0
#define FILL_EEPROM_BUFFER		0
#define PROGRAM_EEPROM			0
#define VERIFY_EEPROM			0
#define SWITCH_TO_APPLI			0
#define VERIFY_IN_APPLI_MODE	0
#define GOBACKTO_ISP			0
#define VERIFY_POST_BACKTO_ISP	0
#define TOGGLE_DTR 1  // Activates DTR signal toggling test.

const TABDOTWIDTH = 40;
const TABFAIL     =  4;



// ======================== Functions prototypes =============================


/*!
******************************************************************************
\fn         void writeTitle()
\brief	    Displays the application name in the console window title area.
******************************************************************************
*/
void writeTitle();

/*!
******************************************************************************
\fn         void setOperationTitle(string str)
\brief	    Displays the on going operation name.
\param      str     The text to be displayed
******************************************************************************
*/
void setOperationTitle(string str);

/*!
******************************************************************************
\fn         void display(int status)
\brief	    Displays the ISP command result; PASS or FAIL.
\param      status      0 if FAIL, 1 if PASS
******************************************************************************
*/
void display(int status, bool newLine = true);

/*!
******************************************************************************
\fn         void loadLibFuncs(HINSTANCE h)
\brief	    Get the addresses of the atisp library functions.
\param      HINSTANCE h     handle of the dynamically loaded library
******************************************************************************
*/
void loadLibFuncs(HINSTANCE h);



#endif // _ISPTEST_H_