/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import hhapplet.ViewSkin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Vector;

public class BsscImagePanel
extends Panel
implements Runnable {
    private Image m_bgImage;
    private int m_nbgWidth;
    private int m_nbgHeight;
    private Image m_cachebgImage;
    private int m_nOldWidth;
    private int m_nOldHeight;
    private boolean m_bBgUpdated;
    private Image m_imgbackground;
    private Vector m_vToDo;

    private Image getBackgroundImage() {
        if (this.m_nbgWidth <= 0 || this.m_nbgHeight <= 0 || this.m_bgImage == null) {
            return null;
        }
        Rectangle rectangle = this.getBounds();
        if (rectangle.height == this.m_nOldHeight && rectangle.width == this.m_nOldWidth && !this.m_bBgUpdated) {
            return this.m_cachebgImage;
        }
        this.m_nOldWidth = rectangle.width;
        this.m_nOldHeight = rectangle.height;
        this.m_cachebgImage = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics = this.m_cachebgImage.getGraphics();
        this.drawBackGround(graphics);
        return this.m_cachebgImage;
    }

    public BsscImagePanel() {
        if (ViewSkin.m_PaneColorBg != null) {
            this.setBackground(ViewSkin.m_PaneColorBg);
        }
        if (ViewSkin.m_PaneImageBg != null) {
            this.setBgImage(ViewSkin.m_PaneImageBg);
        }
        this.m_vToDo = new Vector();
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            Rectangle rectangle = this.getBounds();
            Image image = this.createImage(rectangle.width, rectangle.height);
            Graphics graphics2 = image.getGraphics();
            this.m_imgbackground = this.getBackgroundImage();
            if (this.m_imgbackground != null) {
                graphics2.drawImage(this.m_imgbackground, 0, 0, this);
            }
            graphics.drawImage(image, 0, 0, this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setBgImage(Image image) {
        this.m_bgImage = image;
        this.m_nbgHeight = this.m_bgImage.getHeight(this);
        this.m_nbgWidth = this.m_bgImage.getWidth(this);
    }

    public void dispatchToDo(String string) {
        if (string == "repaint") {
            this.repaint();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image == this.m_bgImage) {
            this.m_nbgWidth = n4;
            this.m_nbgHeight = n5;
            this.m_bBgUpdated = true;
            this.repaint();
            return false;
        }
        return true;
    }

    public void drawBackGround(Graphics graphics) {
        if (this.m_nbgWidth > 0 && this.m_nbgHeight > 0 && this.m_bgImage != null) {
            Rectangle rectangle = this.getBounds();
            int n = 0;
            while (n <= (rectangle.width - 1) / this.m_nbgWidth) {
                int n2 = 0;
                while (n2 <= (rectangle.height - 1) / this.m_nbgHeight) {
                    if (!graphics.drawImage(this.m_bgImage, n * this.m_nbgWidth, n2 * this.m_nbgHeight, this.m_nbgWidth, this.m_nbgHeight, null)) {
                        this.setTimeout("repaint", 100);
                        return;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.m_bBgUpdated) {
                this.m_bBgUpdated = false;
                return;
            }
        } else {
            Color color = graphics.getColor();
            Color color2 = this.getBackground();
            graphics.setColor(color2);
            Rectangle rectangle = this.getBounds();
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void run() {
        ToDo toDo;
        Vector vector = this.m_vToDo;
        synchronized (vector) {
            toDo = (ToDo)this.m_vToDo.elementAt(0);
            this.m_vToDo.removeElementAt(0);
            Object var4_3 = null;
        }
        try {
            Thread.sleep(toDo.m_nMSec);
            this.dispatchToDo(toDo.m_sToDo);
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
    }

    public final void setTimeout(String string, int n) {
        ToDo toDo = new ToDo(string, n);
        Vector vector = this.m_vToDo;
        synchronized (vector) {
            this.m_vToDo.addElement(toDo);
            Object var6_5 = null;
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    private class ToDo {
        public String m_sToDo;
        public int m_nMSec;

        public ToDo(String string, int n) {
            BsscImagePanel.this.getClass();
            this.m_sToDo = string;
            this.m_nMSec = n;
        }
    }
}

